define([
    'underscore',
    'modules/page/popup/popup-view',
    'text!modules/notification-info/notification-info.html',
    'json!notificationInfoJson',
],
function (_, PopupView, template, metadata) {
    'use strict';

    return PopupView.extend({
        template: _.template(template),
        id: 'notification-info',

        initialize: function(options) {
            this.isForCommunityCare = options.isForCommunityCare || false;
            this._initializeElAfterClose(options);
        },
        templateContext: function() {
            return {
                notificationInfo: this.isForCommunityCare ?
                    metadata.communityCareNotificationInfo :
                    metadata.notificationInfo};
        },
    });
});
